import { StarXpandCommand } from "star-io10-web";

export class LabelSample03_For203dpiAnd300dpi_DrinkLabel2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 48.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(48.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // By setting the base print size of text to x1.5 for 300dpi,
            // you can print text at the same size as 203dpi.
            //.styleBaseMagnification(new BaseMagnificationParameter().setText(BaseMagnification.X1_5))
            .actionPrintText("Item: ${item_number%2d} of ${number_of_items}\n")
            .actionPrintText("Items in order: ${items_in_order}")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionFeed(6.0)
                .actionPrintText("${customer_name}")
                .actionFeed(8.0)
                .actionPrintText("${product_name}")
                .actionFeed(6.0),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              ).actionPrintText("${item_list.detail}\n"),
            )
            .actionPrintText("\nTime: ${time}\n")
            .actionPrintText("\n${order_types}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "item_number" : 1,
    "number_of_items" : 1,
    "items_in_order" : 1,
    "customer_name" : "*John Smith*",
    "product_name" : "Star Mocha",
    "item_list" : [
        {
            "detail" : "Caramel Syrup"
        },
        {
            "detail" : "2 pumps Classic Syrup"
        },
        {
            "detail" : "4 pumps Peppermint Syrup"
        },
        {
            "detail" : "No Toffee Nut Syrp"
        },
        {
            "detail" : "1 pump White Mocha"
        },
        {
            "detail" : "3 pumps Mocha"
        },
        {
            "detail" : "Caramel Sauce"
        },
        {
            "detail" : "4 pumps Toasted Wc Sa"
        },
        {
            "detail" : "Warm"
        },
        {
            "detail" : "Extra Foam"
        },
        {
            "detail" : "Extra Whip"
        },
        {
            "detail" : "Ex Mocha Drizzle"
        },
        {
            "detail" : "Ex Vanilla Powder"
        },
        {
            "detail" : "Lt Salt Topping"
        },
        {
            "detail" : "Ex Caramel Sugar"
        }
    ],
    "time" : "6:21:34 PM",
    "order_types" : ">MOBILE<"
}`,
    );
  }
}
